/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASMessageEvent;
import com.ibm.ras.RASMessageFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;

public class MessageFormatter
extends RASMessageFormatter {
    String myhome = "<unknown>";

    public MessageFormatter() {
        this.setSeparator(":");
        this.setDateFormat(new SimpleDateFormat("yyyy.MM.dd"));
        this.setTimeFormat(new SimpleDateFormat("HH:mm:ss.SSS z"));
        this.getDate(0L);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.myhome = inetAddress.getHostAddress();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public String format(RASIEvent rASIEvent) {
        RASMessageEvent rASMessageEvent = (RASMessageEvent)rASIEvent;
        StringBuffer stringBuffer = new StringBuffer(256);
        Exception exception = (Exception)rASIEvent.getAttribute("exception");
        Object[] objectArray = rASIEvent.getParameters();
        stringBuffer.append(this.myhome).append('/');
        String string = (String)rASIEvent.getAttribute("sender");
        if (string == null) {
            stringBuffer.append("server").append(" - ");
        } else {
            stringBuffer.append(string).append(" - ");
        }
        long l = rASMessageEvent.getTimeStamp();
        stringBuffer.append(this.getDate(l)).append(' ');
        stringBuffer.append(this.getTime(l)).append(' ');
        stringBuffer.append(Thread.currentThread().getThreadGroup().getName()).append(' ');
        long l2 = rASIEvent.getType();
        if (exception != null) {
            stringBuffer.append("<X> ");
        } else if (l2 == 1L) {
            stringBuffer.append("<I> ");
        } else if (l2 == 2L) {
            stringBuffer.append("<W> ");
        } else if (l2 == 4L) {
            stringBuffer.append("<E> ");
        } else {
            stringBuffer.append("<?> ");
        }
        String string2 = (String)rASMessageEvent.getAttribute("className");
        String string3 = (String)rASMessageEvent.getAttribute("methodName");
        if (string2.equals("ibm.nways.ras.LogPrintStream") && string3.equals("println")) {
            stringBuffer.append("***");
        } else {
            stringBuffer.append(string2).append("::").append(string3).append("()");
        }
        if (exception == null) {
            String string4 = rASMessageEvent.getMessageFile();
            if (string4 == null) {
                stringBuffer.append(" - ").append(rASMessageEvent.getText());
            } else {
                try {
                    RASMessageCatalog rASMessageCatalog = new RASMessageCatalog(string4);
                    stringBuffer.append(" - ").append(rASMessageCatalog.getMessage(rASMessageEvent.getText(), objectArray));
                }
                catch (MissingResourceException missingResourceException) {
                    stringBuffer.append("Error accessing message catalog");
                }
            }
        } else {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(" - ").append(stringWriter.toString());
        }
        return stringBuffer.toString();
    }
}

